<?php
include('db.php'); // Include database connection

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

// Assign input data to variables
$order_id = mysqli_real_escape_string($conn, $data['order_id']);
$invoice_id = mysqli_real_escape_string($conn, $data['invoice_id']);
$customerid = mysqli_real_escape_string($conn, $data['customerid']);
$shipping = (float)$data['Shipping'];
$roundoff = (float)$data['Roundoff'];
$discount_percentage = (float)$data['Discount_percentage'];
$balance = (float)$data['Balance'];
$paymentid = mysqli_real_escape_string($conn, $data['paymentid']);
$products = $data['Products'];

$grand_total = 0;
$tax_total = 0;
$discount_total = 0;
$product_total = 0;
$total_savings = 0;
$total_discount = 0;

// Fetch customer details
$user_query = "SELECT displayname FROM customer WHERE id = '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (mysqli_num_rows($user_result) > 0) {
    $user_data = mysqli_fetch_assoc($user_result);
    $displayname = mysqli_real_escape_string($conn, $user_data['displayname']);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    // Fetch product details
    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }

    $mrp = (float)$product_data['MRP'];
    $sale_price_tax = (int)$product_data['sale_price_tax'];

    // Calculate values
    $discount = ($selling_price * $discount_percentage) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = 0;

    if ($sale_price_tax == 2) {
        $tax = ($product_subtotal * $tax_percentage) / 100;
    }

    $product_total += $product_subtotal;
    $tax_total += $tax;
    $discount_total += $discount * $qty;
    $total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');

// Update `orders`
$created_date = date('Y-m-d H:i:s');
$due_date = date('Y-m-d', strtotime('+7 days'));

$order_query = "
    UPDATE orders
    SET
        user_id = '$customerid',
        displayname = '$displayname',
        Created_date = '$created_date',
        Due_date = '$due_date',
        Balance = '$balance',
        Tax = '$tax_total',
        Discount = '$discount_total',
        Discount_percentage = '$discount_percentage',
        Shipping = '$shipping',
        Roundoff = '$roundoff',
        Total_price = '$product_total',
        Grand_total = '$grand_total1',
        No_of_items = '" . count($products) . "',
        Total_saving = '$total_savings',
        Total_discount = '$discount_total',
        Payment_status = " . ($balance == 0 ? 1 : ($balance < $grand_total ? 2 : 0)) . ",
        Payment_id = CONCAT(COALESCE(Payment_id, ''), IF(Payment_id IS NULL OR Payment_id = '', '', ','), '$paymentid')
    WHERE Order_id = '$order_id'";

if (!mysqli_query($conn, $order_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update order.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

// Mark existing order_data records for deletion
$order_data_update_query = "
    UPDATE order_data 
    SET Delete_status = 1
    WHERE Order_id = '$order_id'";
mysqli_query($conn, $order_data_update_query);

// Insert updated product data into `order_data`
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $product_query2 = "SELECT MRP, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);

    $product_data2 = mysqli_fetch_assoc($product_result2);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $MRP = (float)$product_data2['MRP'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;
    $Sale_Price_Tax = $product_data2['sale_price_tax'];

    // Insert into `order_data`
    $order_data_insert_query = "
        INSERT INTO order_data (
            Order_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, salepricetax, Product_total, Delete_status
        ) VALUES (
            '$order_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$Sale_Price_Tax', '$product_subtotal', 0
        )";
    mysqli_query($conn, $order_data_insert_query);

    // Update product stock
    $update_product_query = "
        UPDATE product 
        SET qty = qty - '$qty' 
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_product_query);
    
    $update_inventory_query = "UPDATE inventory  
        SET Qty = Qty - '$qty',
        date_modified = NOW()
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_inventory_query);
}

// Return success message
echo json_encode([
    'status' => 'success',
    'message' => 'Order updated successfully.'
]);
?>